<?php 
include_once "../conexao/functions.php";


?>
<!DOCTYPE html>
<html lang="pt-br">
<?php include_once "./includes/head.php"; ?>
<body class="dark-only">
  <!-- Loader starts-->
  <div class="loader-wrapper">
    <div class="loader-index"><span></span></div>
    <svg>
      <defs></defs>
      <filter id="goo">
        <fegaussianblur in="SourceGraphic" stddeviation="11" result="blur"></fegaussianblur>
        <fecolormatrix in="blur" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 19 -9" result="goo">    </fecolormatrix>
      </filter>
    </svg>
  </div>
  <!-- Loader ends-->
  <!-- page-wrapper Start-->
  <div class="page-wrapper compact-wrapper" id="pageWrapper">
    <?php include_once "./includes/header.php"; ?>
    <!-- Page Body Start-->
    <div class="page-body-wrapper sidebar-icon">
      <!-- Page Sidebar Start-->
      <?php include_once "./includes/menu.php"; ?>
      <!-- Page Sidebar Ends-->
      <div class="page-body">
        <div class="container-fluid">
          <div class="page-header">
            <div class="row">
              <div class="col-lg-6">
                <h3>Aplicativos</h3>
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="index-2.html"><i data-feather="home"></i></a></li>
                  <li class="breadcrumb-item active">Meus aplicativos</li>
                </ol>
              </div>
              <div class="col-lg-6">
                <!-- Bookmark Start-->
                <div class="bookmark pull-right">
                  <ul>
                    <li><button class="btn btn-pill btn-success btn-air-success btn-air-success" id="<?php echo $admin_id; ?>" onclick="adicionarApp(this)" type="button">Adicionar aplicativo<i class="fa fa-plus ml-2"></i></button></li>
                  </ul>
                </div>
                <!-- Bookmark Ends-->
              </div>
            </div>
          </div>
        </div>
        <!-- Container-fluid starts-->
        <div class="container-fluid">
          <div class="row">
            <div class="col-xl-12">
              <div class="row">

                <?php  
                $meusApps = buscarApps();
                foreach ($meusApps as $key => $value) {
                  $ID_app     = $value['ID'];
                  $nome_app   = $value['Nome'];
                  $link_app   = $value['Link'];
                  $status_app = $value['Status'];
                  $imagem_app = $value['Imagem'];
                  ?>

                  <div class="col-xl-4 col-sm-4 box-col-4">
                    <div class="card">
                      <div class="blog-box blog-grid text-center product-box">
                        <div class="product-img"><img class="img-fluid top-radius-blog" src="./actions/<?php echo $imagem_app; ?>" alt="">
                        </div>
                        <div class="blog-details-main">
                          <ul class="blog-social">
                            <li class="digits"><button class="btn btn-pill btn-outline-primary btn-air-primary btn-xs" id="<?php echo $ID_app; ?>" onclick="editarApp(this)" type="button">Editar aplicativo</button></li>
                            <li class="digits"><button class="btn btn-pill btn-outline-secondary btn-air-secondary btn-xs" id="<?php echo $ID_app; ?>" onclick="excluirApp(this)" type="button">Excluir aplicativo</button></li>
                            <li class="digits"><button class="btn btn-pill btn-<?php echo $status_app != 1 ? "danger" : "success"; ?> btn-air-<?php echo $status_app != 1 ? "danger" : "success"; ?> btn-xs" id="<?php echo $ID_app; ?>" onclick="statusApp(this)" type="button"><?php echo $status_app != 1 ? "Desativado" : "Publicado"; ?></button></li>
                          </ul>
                          <hr>
                          <h6 class="blog-bottom-details"><?php echo $nome_app; ?></h6>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?>

                <?php  
                if (empty($meusApps)) { ?>
                  <div class="col-xl-12 col-sm-12 box-col-12 text-center">
                    <h3>Você ainda não adicionou nenhum aplicativo</h3>
                    <img src="./assets/images/3024051.png" width="35%">
                  </div>
                <?php } ?>

              </div>
            </div>



          </div>
        </div>
        <!-- Modal de editar clientes -->
        <div class="modal fade bd-example-modal-lg" id="exampleModalgetbootstrap" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document" id="modal_jef">

          </div>
        </div>
        <!-- Fim modal -->
        <!-- Container-fluid Ends-->
      </div>
      <!-- footer start-->
      <?php include_once "./includes/footer.php"; ?>
    </div>
  </div>
  <!-- latest jquery-->
  <script src="assets/js/jquery-3.5.1.min.js"></script>
  <!-- Bootstrap js-->
  <script src="assets/js/bootstrap/popper.min.js"></script>
  <script src="assets/js/bootstrap/bootstrap.js"></script>
  <!-- feather icon js-->
  <script src="assets/js/icons/feather-icon/feather.min.js"></script>
  <script src="assets/js/icons/feather-icon/feather-icon.js"></script>
  <!-- Sidebar jquery-->
  <script src="assets/js/sidebar-menu.js"></script>
  <script src="assets/js/config.js"></script>
  <!-- Plugins JS start-->
  <script src="assets/js/tooltip-init.js"></script>
  <!-- Plugins JS Ends-->
  <!-- Theme js-->
  <script src="assets/js/script.js"></script>
  <script src="assets/js/notify/bootstrap-notify.min.js"></script>
  <!-- login js-->
  <!-- Plugin used-->
  <script src="assets/js/sweet-alert/swalert.js" aria-hidden="true"></script>

  <script type="text/javascript">
    function adicionarApp(obj){
      $.ajax({
        type: "POST",
        url: "actions/adicionar_app.php",
        data: "admin_id="+obj.id,
        success: function(msg)
        {
          $("#exampleModalgetbootstrap").modal("toggle");
          $("#modal_jef").html(msg);
        }
      });
    }
  </script>

  <script type="text/javascript">
    function editarApp(obj){

      console.log(obj.id);
      $.ajax({
        type: "POST",
        url: "./actions/editar_app.php",
        data: "app_id="+obj.id,
        success: function(msg)
        {
          $("#exampleModalgetbootstrap").modal("toggle");
          $("#modal_jef").html(msg);
        }
      });
    }
  </script>

  <script type="text/javascript">
   function statusApp(obj){

    const swalWithBootstrapButtons = Swal.mixin({
      customClass: {
        confirmButton: 'btn btn-success',
        cancelButton: 'btn btn-danger'
      },
      buttonsStyling: false
    })


    Swal.fire({
      title: 'Ativar/Desativar app?',
      text: "Você deseja ativar ou desativar o aplicativo?",
      icon: 'question',
      showCancelButton: true,
      confirmButtonColor: '#7B67FE',
      cancelButtonColor: '#F73567',
      confirmButtonText: 'Sim, desejo'
    }).then((result) => {
      if (result.value) {
        $.ajax({
          type: "POST",
          url: "actions/status_app.php",
          data: "app_id="+obj.id,
          cache: false,
          success: function(response) {
            if (response) {
              Swal.fire(
                'Aplicativo Ativado/Desativado',
                'O aplicativo foi ativado/desativado com sucesso',
                'success'
                )

              setTimeout(function() {
                document.location.reload(true);
              }, 2000);
            }else{
              Swal.fire(
                'Erro ao desativar app!',
                'Seu aplicativo não foi ativado/desativado',
                'error'
                )
            }
          }
        });
      }else if (
        /* Read more about handling dismissals below */
        result.dismiss === Swal.DismissReason.cancel
        ) {
        swalWithBootstrapButtons.fire(
          'Cancelado',
          'Sua ação foi cancelada a tempo. Tome cuidado ao realizar qualquer ação de exclusão dentro do painel. Não será possível reverter a sua ação.',
          'error'
          )
      }
    })
  }
</script>

<script type="text/javascript">
    function editarApp(obj){

      console.log(obj.id);
      $.ajax({
        type: "POST",
        url: "./actions/editar_app.php",
        data: "app_id="+obj.id,
        success: function(msg)
        {
          $("#exampleModalgetbootstrap").modal("toggle");
          $("#modal_jef").html(msg);
        }
      });
    }
  </script>

  <script type="text/javascript">
   function excluirApp(obj){

    const swalWithBootstrapButtons = Swal.mixin({
      customClass: {
        confirmButton: 'btn btn-success',
        cancelButton: 'btn btn-danger'
      },
      buttonsStyling: false
    })


    Swal.fire({
      title: 'Deseja excluir o app?',
      text: "Você deseja excluir esse aplicativo?",
      icon: 'question',
      showCancelButton: true,
      confirmButtonColor: '#7B67FE',
      cancelButtonColor: '#F73567',
      confirmButtonText: 'Sim, desejo'
    }).then((result) => {
      if (result.value) {
        $.ajax({
          type: "POST",
          url: "actions/excluir_app.php",
          data: "app_id="+obj.id,
          cache: false,
          success: function(response) {
            if (response) {
              Swal.fire(
                'Aplicativo excluído',
                'O aplicativo foi excluído com sucesso',
                'success'
                )

              setTimeout(function() {
                document.location.reload(true);
              }, 2000);
            }else{
              Swal.fire(
                'Erro ao excluir app!',
                'Seu aplicativo não foi excluído',
                'error'
                )
            }
          }
        });
      }else if (
        /* Read more about handling dismissals below */
        result.dismiss === Swal.DismissReason.cancel
        ) {
        swalWithBootstrapButtons.fire(
          'Cancelado',
          'Sua ação foi cancelada a tempo. Tome cuidado ao realizar qualquer ação de exclusão dentro do painel. Não será possível reverter a sua ação.',
          'error'
          )
      }
    })
  }
</script>

<?php 
if (isset($_GET["r"])) {
  $result = $_GET["r"];
  switch ($result) {
    case "app_adicionado":
    echo "<script src='assets/js/notify/index.js'></script>";
    break;
    case "app_erro":
    echo "<script src='assets/js/notify/erro.js'></script>";
    break;
    case "app_editado":
    echo "<script src='assets/js/notify/sucesso_app.js'></script>";
    break;
    case "app_erro_edit":
    echo "<script src='assets/js/notify/erro_app.js'></script>";
    break;
  }
}
?>
</body>
</html>